/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.api.VWMapNode;
import filenet.vw.toolkit.design.mapui.VWDesignerMapToolbar;
import filenet.vw.toolkit.design.palette.VWBaseStepPalettePanel;
import filenet.vw.toolkit.design.palette.VWDraggablePaletteItemUI;
import filenet.vw.toolkit.design.palette.VWIconViewPanel;
import filenet.vw.toolkit.design.palette.VWStepPaletteDocumentHelper;
import filenet.vw.toolkit.design.palette.VWStepPaletteItemUI;
import filenet.vw.toolkit.design.palette.VWStepPaletteMenu;
import filenet.vw.toolkit.design.palette.VWStepPaletteWrapper;
import filenet.vw.toolkit.design.palette.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWBaseImageLoader;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;

public class VWStepPalettePanel
extends VWBaseStepPalettePanel
implements ActionListener,
IVWCoordinationEventListener {
    private AbstractButton m_paletteMenuButton = null;
    private VWStepPaletteMenu m_stepPaletteMenu = null;
    private VWPopupMenu m_editablePaletteStepMenu = null;
    private JMenuItem m_deleteContextMenuItem = null;

    public void initialize(VWAuthPropertyData authPropertyData, VWDesignerMapToolbar mapToolbar) {
        super.initialize(authPropertyData, mapToolbar);
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    public void addStepToPalette(String stepPaletteName, VWMapNode newStep) throws Exception {
        VWStepPaletteWrapper stepPaletteWrapper;
        if (stepPaletteName == null || stepPaletteName.length() == 0) {
            stepPaletteName = VWResource.s_myPaletteOption;
        }
        if ((stepPaletteWrapper = this.m_stepPaletteMenu.findStepPalette(stepPaletteName)) != null && newStep != null) {
            stepPaletteWrapper.addStep(newStep);
        }
    }

    public void setSelected() {
        VWStepPaletteDocumentHelper stepPaletteHelper = this.getStepPaletteDocumentHelper();
        VWStepPaletteWrapper[] stepPaletteWrappers = this.m_stepPaletteMenu.getSelectedStepPalettes();
        stepPaletteHelper.updateStepPaletteDialog(this, stepPaletteWrappers);
    }

    public void releaseReferences() {
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().removeCoordinationEventListener(this);
        if (this.m_stepPaletteMenu != null) {
            this.m_stepPaletteMenu.releaseReferences();
            this.m_stepPaletteMenu = null;
        }
        if (this.m_paletteMenuButton != null) {
            this.m_paletteMenuButton.removeActionListener(this);
            this.m_paletteMenuButton = null;
        }
        if (this.m_editablePaletteStepMenu != null) {
            Component[] items = this.m_editablePaletteStepMenu.getComponents();
            if (items != null) {
                for (int nIndex = 0; nIndex < items.length; ++nIndex) {
                    if (!(items[nIndex] instanceof JMenuItem)) continue;
                    ((JMenuItem)items[nIndex]).removeActionListener(this);
                }
            }
            this.m_editablePaletteStepMenu.removeAll();
            this.m_editablePaletteStepMenu = null;
        }
        this.m_deleteContextMenuItem = null;
        super.releaseReferences();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_paletteMenuButton)) {
            if (this.m_stepPaletteMenu != null) {
                this.m_stepPaletteMenu.show(this.m_paletteMenuButton, this.m_paletteMenuButton.getWidth(), 0);
            }
        } else if (source.equals(this.m_deleteContextMenuItem)) {
            this.performDeleteItemAction();
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 752: {
                VWStepPaletteWrapper updatedMyPaletteWrapper = (VWStepPaletteWrapper)event.getEventParam();
                if (updatedMyPaletteWrapper == null || !this.m_stepPaletteMenu.updateStepPaletteMenuItem(updatedMyPaletteWrapper)) break;
                this.handleStepPaletteSelectionAction();
                break;
            }
            case 750: 
            case 751: {
                this.handleStepPaletteSelectionAction();
            }
        }
    }

    protected void createControls(VWDesignerMapToolbar mapToolbar) {
        this.m_iconViewPanel = new VWIconViewPanel(this);
        this.m_iconViewPanel.setName("m_iconViewPanel_VWStepPalettePanel");
        mapToolbar.addComponentListener(this.m_iconViewPanel);
        mapToolbar.add(this.m_iconViewPanel);
        this.m_stepPaletteMenu = new VWStepPaletteMenu(this);
        if (this.m_stepPaletteMenu != null) {
            this.m_paletteMenuButton = VWImageLoader.createToolBarButton("tearOff.gif", VWResource.s_paletteMenu, false);
            this.m_paletteMenuButton.setName("m_paletteMenuButton_VWIconViewPanel");
            this.m_paletteMenuButton.setBorder(BorderFactory.createEmptyBorder());
            this.m_paletteMenuButton.setContentAreaFilled(false);
            this.m_paletteMenuButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_paletteMenuButton);
            mapToolbar.add(this.m_paletteMenuButton);
            this.handleStepPaletteSelectionAction();
        }
    }

    protected VWPopupMenu getStepContextMenu() {
        if (this.m_editablePaletteStepMenu == null) {
            this.m_editablePaletteStepMenu = new VWPopupMenu();
            this.m_deleteContextMenuItem = VWStringUtils.getMenuItemUsingString(VWResource.s_deleteStr);
            if (this.m_deleteContextMenuItem != null) {
                this.m_deleteContextMenuItem.addActionListener(this);
                this.m_editablePaletteStepMenu.add(this.m_deleteContextMenuItem);
            }
        }
        return this.m_editablePaletteStepMenu;
    }

    protected void displayStepPaletteDialog() {
        VWStepPaletteDocumentHelper stepPaletteHelper = this.getStepPaletteDocumentHelper();
        stepPaletteHelper.displayStepPaletteDialog(true, this, this.m_stepPaletteMenu.getSelectedStepPalettes());
    }

    protected VWDraggablePaletteItemUI getSelectedUIItem() {
        if (this.m_stepPaletteMenu != null) {
            return this.m_stepPaletteMenu.getSelectedUIItem();
        }
        return null;
    }

    protected void setSelectedUIItem(VWDraggablePaletteItemUI paletteItemUI) {
        if (this.m_stepPaletteMenu != null) {
            this.m_stepPaletteMenu.setSelectedUIItem(paletteItemUI);
        }
    }

    protected void handleStepPaletteSelectionAction() {
        VWStepPaletteWrapper[] stepPaletteWrappers = this.m_stepPaletteMenu.getSelectedStepPalettes();
        VWStepPaletteDocumentHelper stepPaletteHelper = this.getStepPaletteDocumentHelper();
        stepPaletteHelper.setSelectedStepPalettes(stepPaletteWrappers);
        this.m_iconViewPanel.displayPalettes(stepPaletteWrappers);
    }

    protected void performDeleteItemAction() {
        VWStepPaletteItemUI vwStepPaletteItemUI;
        VWStepPaletteWrapper stepPaletteWrapper;
        VWDraggablePaletteItemUI paletteItemUI = null;
        if (this.m_stepPaletteMenu != null) {
            paletteItemUI = this.m_stepPaletteMenu.getSelectedUIItem();
        }
        if (paletteItemUI != null && paletteItemUI instanceof VWStepPaletteItemUI && (stepPaletteWrapper = (vwStepPaletteItemUI = (VWStepPaletteItemUI)paletteItemUI).getStepPaletteWrapper()) != null) {
            stepPaletteWrapper.removeStep(vwStepPaletteItemUI.getMapNode(), this.m_authPropertyData.getDesignerCoreData().getParentFrame());
            this.setSelectedUIItem(null);
        }
    }
}

